/*
 * Copyright (c) 2020, The Linux Foundation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * Neither the name of The Linux Foundation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

static const int8_t effect_1[] = {
    1,   1,   1,   1,   1,   2,   2,   2,   3,   4,   5,   6,   7,   9,   11,
    13,  16,  19,  22,  26,  29,  34,  37,  41,  44,  47,  49,  51,  52,  54,
    55,  56,  57,  57,  58,  58,  58,  58,  58,  58,  58,  57,  57,  56,  55,
    54,  52,  51,  48,  46,  42,  39,  35,  29,  24,  17,  10,  2,   -6,  -14,
    -20, -27, -32, -37, -41, -44, -47, -49, -52, -54, -55, -56, -57, -57, -57,
    -58, -58, -58, -57, -57, -56, -55, -54, -52, -50, -48, -45, -42, -38, -33,
    -28, -22, -15, -8,  0,   8,   15,  22,  28,  33,  38,  42,  45,  48,  50,
    52,  53,  54,  55,  56,  57,  57,  57,  57,  57,  56,  55,  54,  53,  51,
    49,  47,  44,  40,  35,  30,  24,  16,  8,   -2,  -14, -24, -32, -39, -44,
    -47, -50, -52, -54, -55, -56, -57, -57, -57, -57, -57, -56, -55, -54, -52,
    -50, -48, -46, -44, -41, -39, -37, -35, -33, -31, -29, -27, -25, -23, -21,
    -20, -18, -16, -15, -14, -12, -11, -9,  -8,  -7,  -6,  -5,  -4,  -3,  -2,
    -1,  -1,  0,   1,   2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   6,
    6,   6,   6,   6,   6,   6,   7,   7,   7,   7,   7,   7,   7,   7,   7,
    7,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   5,   5,   5,   5,
    5,   5,   5,   5,   4,   4,   4,   4,   4,   4,   4,   3,   3,   3,   3,
    2,   2,   2,   2,   2,   2,   2,   2,   2,   1,   1,   1,   1,   1,   1,
    1,   1,   1,   1,   1,   1,   1,   0
};

static const int8_t effect_2[] = {
    0,    1,    1,    2,    2,    3,    4,    5,    6,    8,    11,   13,
    15,   19,   22,   26,   30,   35,   40,   44,   51,   56,   62,   68,
    73,   80,   85,   91,   97,   102,  106,  111,  115,  118,  121,  124,
    126,  127,  127,  127,  126,  125,  122,  120,  117,  112,  108,  103,
    97,   91,   85,   77,   71,   63,   55,   47,   39,   31,   22,   14,
    6,    -1,   -10,  -17,  -24,  -32,  -39,  -45,  -51,  -57,  -62,  -66,
    -71,  -74,  -77,  -79,  -80,  -81,  -81,  -80,  -79,  -76,  -73,  -70,
    -65,  -60,  -55,  -49,  -41,  -35,  -27,  -19,  -10,  -2,   6,    14,
    23,   31,   39,   47,   55,   62,   68,   75,   80,   85,   89,   93,
    96,   99,   101,  102,  103,  103,  103,  102,  101,  100,  97,   95,
    93,   89,   86,   83,   80,   76,   72,   68,   65,   61,   56,   52,
    49,   44,   40,   36,   32,   29,   24,   20,   16,   13,   9,    5,
    2,    -1,   -4,   -8,   -10,  -13,  -16,  -17,  -19,  -20,  -21,  -21,
    -21,  -21,  -21,  -20,  -20,  -19,  -18,  -17,  -16,  -16,  -14,  -14,
    -12,  -12,  -11,  -10,  -10,  -9,   -9,   -8,   -8,   -7,   -7,   -6,
    -6,   -6,   -5,   -5,   -4,   -4,   -4,   -4,   -3,   -2,   -3,   -3,
    -3,   -3,   -3,   -2,   -1,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
    -2,   -2,   -1,   0
};

static const int8_t effect_3[] = {
    1,    1,    1,    1,    2,    2,    2,    3,    4,    4,    5,    6,
    7,    8,    10,   12,   14,   16,   19,   22,   25,   29,   33,   38,
    43,   49,   55,   61,   67,   74,   80,   85,   90,   95,   99,   103,
    107,  109,  112,  114,  116,  118,  119,  120,  121,  122,  123,  123,
    124,  124,  124,  124,  123,  123,  122,  121,  120,  119,  118,  116,
    114,  111,  108,  105,  101,  97,   91,   86,   79,   71,   63,   54,
    44,   32,   21,   8,    -5,   -17,  -29,  -41,  -51,  -61,  -70,  -77,
    -84,  -90,  -96,  -100, -104, -108, -111, -113, -116, -117, -119, -120,
    -121, -122, -122, -122, -122, -122, -122, -121, -120, -119, -117, -116,
    -113, -111, -108, -104, -100, -96,  -90,  -84,  -77,  -69,  -61,  -51,
    -41,  -29,  -17,  -5,   8,    21,   33,   44,   54,   63,   71,   79,
    86,   91,   96,   101,  105,  108,  111,  113,  115,  117,  118,  119,
    120,  120,  121,  121,  121,  120,  119,  119,  117,  116,  114,  112,
    109,  106,  102,  97,   92,   86,   79,   71,   62,   52,   40,   27,
    12,   -4,   -22,  -40,  -56,  -69,  -80,  -88,  -95,  -101, -106, -110,
    -113, -115, -117, -119, -120, -121, -121, -121, -121, -121, -120, -119,
    -118, -116, -114, -111, -108, -104, -100, -95,  -90,  -85,  -80,  -75,
    -70,  -65,  -60,  -56,  -51,  -47,  -43,  -39,  -35,  -31,  -28,  -25,
    -22,  -19,  -16,  -13,  -11,  -8,   -6,   -4,   -2,   -1,   1,    3,
    4,    5,    7,    8,    9,    10,   11,   12,   12,   13,   14,   14,
    15,   15,   16,   16,   16,   17,   17,   17,   17,   17,   17,   17,
    17,   17,   17,   17,   17,   17,   17,   17,   17,   17,   16,   16,
    16,   16,   16,   15,   15,   15,   15,   14,   14,   14,   14,   13,
    13,   13,   13,   12,   12,   12,   12,   11,   11,   11,   11,   10,
    10,   10,   10,   9,    9,    9,    9,    8,    8,    8,    8,    8,
    7,    7,    7,    7,    6,    6,    6,    6,    6,    6,    5,    5,
    5,    5,    5,    5,    4,    4,    4,    4,    4,    4,    4,    3,
    3,    3,    3,    3,    3,    3,    3,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    0
};

static const int8_t effect_4[] = {
    0,    1,    0,    2,    2,    3,    4,    5,    6,    8,    10,   12,
    14,   17,   20,   23,   27,   30,   34,   37,   41,   44,   48,   51,
    54,   57,   59,   61,   63,   65,   66,   66,   66,   66,   65,   64,
    62,   60,   58,   55,   51,   47,   43,   39,   34,   29,   23,   18,
    12,   5,    0,    -6,   -11,  -18,  -24,  -30,  -36,  -41,  -47,  -52,
    -57,  -61,  -66,  -70,  -74,  -77,  -80,  -82,  -84,  -86,  -87,  -88,
    -88,  -87,  -86,  -85,  -83,  -80,  -77,  -74,  -70,  -66,  -61,  -56,
    -50,  -45,  -39,  -33,  -26,  -20,  -13,  -5,   0,    7,    13,   18,
    24,   31,   38,   44,   50,   56,   62,   68,   73,   79,   84,   89,
    93,   98,   102,  106,  109,  113,  116,  118,  121,  123,  125,  126,
    127,  127,  127,  127,  126,  125,  122,  120,  116,  112,  107,  102,
    97,   93,   90,   86,   83,   81,   78,   76,   74,   73,   71,   69,
    68,   66,   65,   63,   62,   61,   59,   58,   56,   55,   54,   52,
    51,   49,   48,   47,   45,   44,   43,   41,   40,   39,   37,   36,
    35,   34,   33,   32,   31,   30,   29,   29,   28,   27,   27,   27,
    27,   26,   27,   27,   27,   28,   29,   30,   32,   33,   36,   38,
    41,   44,   48,   53,   59,   65,   72,   79,   85,   90,   95,   99,
    102,  104,  106,  107,  108,  108,  108,  108,  108,  107,  106,  105,
    104,  103,  102,  101,  100,  98,   97,   95,   94,   93,   91,   90,
    88,   87,   85,   84,   82,   81,   79,   78,   76,   75,   74,   72,
    71,   69,   68,   66,   65,   64,   62,   61,   60,   58,   57,   56,
    54,   53,   52,   50,   49,   48,   46,   45,   44,   43,   41,   40,
    39,   38,   37,   35,   34,   33,   32,   31,   30,   28,   27,   26,
    25,   24,   23,   22,   21,   20,   19,   18,   17,   16,   15,   14,
    13,   12,   11,   10,   9,    8,    7,    7,    5,    5,    3,    3,
    2,    2,    0,    0,    -1,   -1,   -1,   -3,   -2,   -4,   -4,   -5,
    -5,   -7,   -6,   -8,   -8,   -9,   -9,   -10,  -10,  -11,  -11,  -12,
    -12,  -13,  -13,  -14,  -14,  -15,  -15,  -16,  -16,  -17,  -17,  -18,
    -18,  -18,  -19,  -19,  -19,  -19,  -20,  -20,  -20,  -21,  -21,  -21,
    -21,  -21,  -22,  -22,  -22,  -22,  -22,  -23,  -23,  -23,  -23,  -23,
    -23,  -23,  -23,  -23,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,
    -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -24,  -23,
    -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,  -23,  -22,  -22,
    -22,  -22,  -22,  -22,  -22,  -21,  -21,  -21,  -21,  -21,  -21,  -20,
    -20,  -20,  -20,  -20,  -20,  -19,  -19,  -19,  -19,  -19,  -18,  -18,
    -18,  -18,  -18,  -17,  -17,  -17,  -17,  -17,  -16,  -16,  -16,  -16,
    -15,  -15,  -15,  -15,  -15,  -14,  -14,  -14,  -14,  -13,  -13,  -13,
    -13,  -13,  -12,  -12,  -12,  -12,  -11,  -11,  -11,  -11,  -11,  -10,
    -10,  -10,  -10,  -9,   -9,   -9,   -9,   -9,   -8,   -8,   -8,   -8,
    -8,   -7,   -7,   -7,   -7,   -7,   -6,   -6,   -6,   -6,   -6,   -5,
    -5,   -5,   -5,   -5,   -5,   -4,   -4,   -4,   -4,   -4,   -2,   -3,
    -3,   -3,   -3,   -3,   -3,   -2,   -1,   -2,   -1,   -2,   -1,   -2,
    0,
};

static const struct effect_stream effects[] = {
    {
        /* CLICK */
        .effect_id = 0,
        .data = effect_2,
        .length = ARRAY_SIZE(effect_2),
        .play_rate_hz = 24000,
    },

    {
        /* DOUBLE_CLICK */
        .effect_id = 1,
        .data = effect_1,
        .length = ARRAY_SIZE(effect_1),
        .play_rate_hz = 24000,
    },

    {
        /* TICK */
        .effect_id = 2,
        .data = effect_2,
        .length = ARRAY_SIZE(effect_2),
        .play_rate_hz = 24000,
    },

    {
        /* THUD */
        .effect_id = 3,
        .data = effect_3,
        .length = ARRAY_SIZE(effect_3),
        .play_rate_hz = 24000,
    },

    {
        /* POP */
        .effect_id = 4,
        .data = effect_4,
        .length = ARRAY_SIZE(effect_4),
        .play_rate_hz = 24000,
    },

    {
        /* HEAVY_CLICK */
        .effect_id = 5,
        .data = effect_3,
        .length = ARRAY_SIZE(effect_3),
        .play_rate_hz = 24000,
    },
};
